from tencentcloud.common import credential
from tencentcloud.sms.v20210111 import sms_client, models
from tencentcloud.common.exception.tencent_cloud_sdk_exception import TencentCloudSDKException
import json
import re


class TencentSMS:

    def __init__(self, secret_id=None, secret_key=None):

        self.__cred = credential.Credential(secret_id, secret_key)

        self.client = sms_client.SmsClient(self.__cred, "ap-guangzhou")

        self.req = models.SendSmsRequest()

    def send_verify_code(self, phone, code, expired):
        if not bool(re.match(r'^1[0-9]{10}', phone)):
            print(phone)
            return {"code": -101, "result": "incorrect phone", "message": "Please check phone number"}
        # 应用ID
        self.req.SmsSdkAppId = '1400834119'
        # 签名信息
        self.req.SignName = 'AmbientGuard'
        # 模板ID
        self.req.TemplateId = '786854'
        # 模板参数 ["验证码", "过期时间"]
        self.req.TemplateParamSet = [code, expired]
        # 电话号码 +86
        self.req.PhoneNumberSet = ["+86" + phone]

        # 发送结果
        try:
            resp = self.client.SendSms(self.req)
        except TencentCloudSDKException as e:
            return {"code": -100, "result": e.code, "message": e.message}

        resp_d = json.loads(resp.to_json_string())
        if resp_d["SendStatusSet"][0]["Code"] != 'Ok':
            return {
                "code": -1,
                "result": resp_d["SendStatusSet"][0]["Code"],
                "msg": resp_d["SendStatusSet"][0]["Message"]
            }
        else:
            return {
                "code": 0,
                "result": resp_d["SendStatusSet"][0]["Code"],
                "msg": resp_d["SendStatusSet"][0]["Message"]
            }


MyTencentSMS = TencentSMS("AKIDqjXoEXwV8i6FMPLD2lJfnjgU6aL4qvy0", "ywoXM5gBd09B1qbQH0Z2LcloiV6UiiWD")

if __name__ == '__main__':
    sms = TencentSMS("AKIDqjXoEXwV8i6FMPLD2lJfnjgU6aL4qvy0", "ywoXM5gBd09B1qbQH0Z2LcloiV6UiiWD")
    x = sms.send_verify_code("+8615517359921", '123456', '100')
    print(x)
