import random
import string
from flask import Blueprint, request, session, url_for, jsonify

from flask_jwt_extended import (create_access_token, get_jwt_identity, jwt_required,
                                JWTManager, current_user)

from ..qq.routes import qq_login
from ..sms import MyTencentSMS
from ..mail import NetEase163MailSender
from ..models import User, db
from ..home.validation import register_user_valid

bp = Blueprint("home", __name__)
jwt = JWTManager()

verify_code = {}


def sms_send(phone):
    sms_code = str(random.randint(100000, 999999))
    set_verify_code(phone, sms_code)
    return MyTencentSMS.send_verify_code(phone, sms_code, "10")


def mail_send(mail):
    mail_code = str(random.randint(100000, 999999))
    set_verify_code(mail, mail_code)
    return NetEase163MailSender.send_verify_code(mail, mail_code)


# 方便后续修改
def set_verify_code(k, v, expired_in=10):
    verify_code[k] = v


def delete_verify_code(key):
    if verify_code.get(key):
        del verify_code[key]


# verify code result
def verify_code_result(key, code):
    r = verify_code.get(key) is not None and verify_code.get(key) == code
    delete_verify_code(key)
    return r


# rand password
def rand_password():
    all_letters = string.ascii_letters + string.digits + "(){}[],._+-="
    return ''.join([random.choice(all_letters) for _ in range(8)])


# 登录
@bp.route("/SmartPlugUsr/", methods=['POST', 'GET'])
def login():
    if request.method == "post":
        method = request.form.get("Method")
        print(method)
        if method == "QQLogin":
            token = request.form.get("QQToken")
            r = qq_login(token)
            if r["code"] == 0:
                # success
                return {"QQUser": r["username"], "QQPwd": r["password"]}
            else:
                return {"Method": "QQLogin", "Status": "1", "Message": r.get("message")}
        elif method == "UploadPhone":
            user_flag = request.form.get("ContactWay")
            if "@" in user_flag:
                r = mail_send(user_flag)
            else:
                r = sms_send(user_flag)
            if r["code"] == 0:
                # success
                return {"Method": method, "Status": "0"}
            else:
                return {"Method": method, "Status": "1", "Message": r.get("message", "")}

        elif method == "SmsVerification":
            code = request.form.get("VerCode")
            phone = request.form.get("PhoneNumber")

            r = code_login(phone, code)

            if r["code"] == 0:
                # success

                r = {"Method": method, "User": r["username"], "Pwd": r["password"], "Status": "0"}
                print(r)
                return r

            else:

                r = {"Method": method, "Status": "1", "Message": r.get("message", "")}
                return r
        elif method == "ConfirmationCode":
            code = request.form.get("AuthCode")
            key = request.form.get("ContactWay")
            if verify_code_result(key, code):
                return {"Method": method, "Message": "SUCCESS", "Status": "0"}
            return {"Method": method, "Message": "FAIL", "Status": "1"}
        elif method == "ModifyingInformation":
            username = request.form.get("Usr")
            user = User.query.filter_by(username=username).one_or_none()
            if not user:
                return {"Method": method, "Status": 1, "Message": "user not exist"}

            modify_dict = {}
            for i in ["userIcon", "userPhone", "userEmail", "nickname"]:
                if request.form.get(i):
                    modify_dict[i] = request.form.get(i)
            if modify_dict.get("userPhone") and \
                    User.check_user_exist("cellphone", modify_dict.get("userPhone")):
                return {"Method": method, "Status": 1, "Message": "phone is exist"}

            if modify_dict.get("userEmail") and \
                    User.check_user_exist("email", modify_dict.get("userEmail")):
                return {"Method": method, "Status": 1, "Message": "Email is exist"}

            for k, v in modify_dict.items():
                setattr(user, k, modify_dict[k])
            try:
                db.session.commit()
                return {"Method": method, "Status": 0, "Message": "success"}
            except Exception as e:
                db.session.rollback()
                return {"Method": method, "Status": 1, "Message": "DataBase Error: {}".format(e)}

        else:
            username = request.args.get("username")
            password = request.args.get("password")

            user = User.check_user_exist(key='username', value=username) or \
                User.check_user_exist(key='cellphone', value=username)
            if user:
                # 验证密码
                if user.check_password(password):
                    # 返回token
                    access_token = create_access_token(identity=user)
                    return jsonify(code=0, access_token=access_token)
                    # return {"code": 0, "user": user.username,
                    #         "password": user.password, "message": "login success"}
                return {"code": -1, "result": "fail", "message": "incorrect password"}
            return {"code": -2, "result": "fail", "message": "incorrect username or cellphone number"}
    else:
        method = request.args.get("Method")
        if method == "GetInformation":
            username = request.args.get("Usr")
            user = User.query.filter_by(username=username).one_or_none()
            if user:
                return {"Method": method, "Usr": user.username,
                        "userEmail": user.email, "userPhone": user.cellphone,
                        "nickname": user.nickname, "userIcon": user.usericon, "Status": "0"}
            return {"Method": method, "Status": 1, "Message": "user not found"}
        else:
            return {"Method": method, "Status": 1, "Message": "check method"}


# 验证码登录
def code_login(phone, code):
    if verify_code_result(phone, code):
        # 验证成功, 判断是否有此手机号的账号
        # 有账号返回账号信息， 无账号 以手机号为用户民注册
        user = User.check_user_exist(key='cellphone', value=phone)
        if not user:
            # 注册 或 返回未找到用户信息
            pwd = rand_password()
            user = User.create_user(username=phone[-11:], password=pwd, cellphone=phone)

        return {"code": 0, "username": user.username, "password": user.pwd, "message": "login success"}

    # 验证码验证失败
    return {"code": -3, "result": 'fail', 'message': 'code verify fail'}


# create_access_token 默认加载的 identity
@jwt.user_identity_loader
def user_identity_loader(user):
    return user.id


# 返回查询User
@jwt.user_lookup_loader
def user_lookup_callback(_jwt_header, jwt_data):
    identity = jwt_data["sub"]
    return User.query.filter_by(id=identity).one_or_none()


@bp.route("/protected-path", methods=["GET"])
@jwt_required()
def test():
    print(current_user)
    return current_user.username


# 注册信息
@bp.route("/register", methods=["POST"])
def register():
    register_data = request.json
    # validation
    valid_data, errors = register_user_valid(register)

    if valid_data:
        # 验证成功
        user = User.create_user(**valid_data)
        if user:
            # 注册成功
            return {"code": 1, "username": user.username, "password": user.password, "mesage": "success"}

        # 失败
        return {"code": -1, "result": "fail", "message": "reg server error"}

    # 验证失败信息
    return {"code": -1, "result": "fail", "message": "register valid error", "errors": errors}
