from flask import Blueprint, request
from website.models import User
from flask_jwt_extended import create_access_token, create_refresh_token
import time
import string
import random
import requests
import json
from json.decoder import JSONDecodeError


bp = Blueprint("qq", __name__)
QQ_AUTH_API = "https://graph.qq.com/"
QQ_APP_ID = '102054664'
QQ_APP_KEY = 'cL3hIrMpFcwCPZfh'
QQ_REDIRECT_URL = 'https://oauth2sp.mlbaeabbserver.cn/qq/r/'

# rand password
def rand_password():
    all_letters = string.ascii_letters + string.digits + "(){}[],._+-="
    return ''.join([random.choice(all_letters) for _ in range(8)])

def qq_login(code):
    # code 获取 token
    token_url = QQ_AUTH_API + \
        'token?grant_type=authorization_code&client_id={}&client_secret={}&redirect_uri={}&code={}'.format(
        QQ_APP_ID, QQ_APP_KEY, QQ_REDIRECT_URL, code)
    
    try:
        qq_toekn_response = requests.get(token_url)
        token_dict = json.loads(qq_toekn_response.text)
    except JSONDecodeError:
        return {"code": -1, "result":"fail", "message": "response decode error: get_token"}
    except Exception as e:
        return {"code": -1, "result":"fail", "message": "network error: get_token"}
    
    if isinstance(token_dict, dict) and token_dict.get("token") is not None:
        token = token_dict.get("token")
    else:
        return {"code": -1, "result":"fail", "message": "token is not in response: get_token"}
    # APP已获取token
    # https://graph.qq.com/oauth2.0/me?access_token=[Access_Token]&unionid=1&fmt=json
    # code 获取 token
    profile_url = QQ_AUTH_API + 'oauth2.0/me?access_token=' + token + '&fmt=json'
    qq_profile_info = None

    try:
        qq_profile_info = requests.get(profile_url, timeout=20)
    except Exception as e:
        # log e 登录失败
        return {"code": -1, "result": "fail", "message": "network error: get_openid"}

    res = json.loads(qq_profile_info.text)
    # 不获取unionid
    # unionid = res.get("unionid")
    openid = res.get("openid")
    return register_from_qq_openid(openid)

def register_from_qq_openid(qq_openid):

    # 判断unionid 是否存在，存在即登录
    user = User.check_user_exist(key='qq_openid', value=qq_openid)
    if not user:
        # 注册 或 返回未找到用户信息
        username = qq_openid[-6:] + str(time.time())[-3:]
        password = rand_password()
        user = User.create_user(username=username, password=password, qq_openid=qq_openid)
        if user:
            # 若使用token验证形式，返回token
            access_token = create_access_token(identity=user)
            refresh_token = create_refresh_token(identity=user)
    try:
        return {"code": 0, "user": user.username, "password": user.password, "message": "login success"}
    except AttributeError:
        # user为None时为添加用户失败，返回登录失败信息
        return {"code": -1, 'result':'fail', "message": "qq login fail"}
