import smtplib
import re
from email.mime.text import MIMEText


code_html = '''
<html>
  <head></head>
  <body>
    <h1>Your Verification Code</h1>
    <p>Thank you for using our service. Your verification code is: <strong>{}</strong></p>
    <p>Please enter this code to proceed.</p>
  </body>
</html>
'''


def validate_email(email):
    pattern = r'^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
    return re.match(pattern, email) is not None


class NetEase163MailSender:

    smtp_server = 'smtp.163.com'
    smtp_port = 25
    sender_mail = 'ambient_guard_auto@163.com'
    sender_pwd = 'PKQDLWUYKYHQDYZZ'

    def __init__(self):
        pass

    @classmethod
    def send_verify_code(cls, mail, code):
        if not validate_email(mail):
            return {"code": -1, "result": "fail", "message": "wrong mail"}
        code_mail = code_html.format(code)
        message = MIMEText(code_mail, 'html')
        message['Subject'] = "AmbientGuard验证码"
        message['From'] = cls.sender_mail
        message['To'] = mail
        try:
            with smtplib.SMTP(cls.smtp_server, cls.smtp_port) as server:
                server.starttls()
                server.login(cls.sender_mail, cls.sender_pwd)
                server.sendmail(cls.sender_mail, mail, message.as_string())

            return {"code": 0, "result": "success", "message": "success"}
        except Exception as e:
            return {"code": -1, "result": "fail", "message": str(e)}


if __name__ == "__main__":
    test_mail = "ly12260130@vip.qq.com"
    verify_code = "123456"
    NetEase163MailSender.send_verify_code(test_mail, verify_code)
