from website.models import User
import re


def password_spec_valid(pwd):
    has_digit = bool(re.search(r'[0-9]', pwd))
    has_ascii_lower = bool(re.search(r'[a-z]', pwd))
    has_ascii_upper = bool(re.search(r'[A-Z]', pwd))
    has_sepcial = bool(re.search(r'[^0-9a-zA-Z]', pwd))

    return has_digit and has_ascii_lower and has_ascii_upper

def register_user_valid(d):
    errors = {}
    username = d.get("username")
    if username:
        if User.check_user_exist(value=username):
            errors["username"] = ["username is exist"]
        # 其他条件 长度 规则等等
        if bool(re.search(r'[^0-9a-zA-Z]', username)):
            errors["username"]  = errors.get("username", [])
            errors["username"].append("username contains sepecial characters")

    else:
        errors["username"] = "username is required"

    password = d.get("password")
    if password:
        if not password_spec_valid(password):
            errors["password"] = ["password should contain numbers and letters"]
    else:
        errors["password"] = "password is required"

    if len(errors) == 0:
        return True, errors
    return False, errors
