import requests
from ..sms import MyTencentSMS
from ..mail import NetEase163MailSender
import random
import string
import json
from flask import Response


verify_code = {}


def redirect_request(r, path):
    old_api = "http://114.32.171.72:8006/" + path
    if r.method == "POST":
        req_data = r.form
        response = requests.post(old_api, data=req_data)
    else:
        req_data = r.args
        response = requests.get(old_api, params=req_data)

    return response.text, response.status_code


def sms_send(phone):
    sms_code = str(random.randint(100000, 999999))
    set_verify_code(phone, sms_code)
    return MyTencentSMS.send_verify_code(phone, sms_code, "10")


def mail_send(mail):
    mail_code = str(random.randint(100000, 999999))
    set_verify_code(mail, mail_code)
    return NetEase163MailSender.send_verify_code(mail, mail_code)


# 方便后续修改
def set_verify_code(k, v, expired_in=10):
    verify_code[k] = v


def delete_verify_code(key):
    if verify_code.get(key):
        del verify_code[key]


# verify code result
def verify_code_result(key, code):
    r = verify_code.get(key) is not None and verify_code.get(key) == code
    delete_verify_code(key)
    return r


# rand password
def rand_password():
    all_letters = string.ascii_letters + string.digits + "(){}[],._+-="
    return ''.join([random.choice(all_letters) for _ in range(8)])


# success response
def success_response(method, code, data=None, message="Success"):
    r = {
        "Method": str(method),
        "Status": str(code),
        "Message": str(message) if message else "",
        "Data": "",
    }
    if data:
        r["Data"] = data

    return Response(
        json.dumps(r, ensure_ascii=False, sort_keys=False, indent=4), mimetype="application/json"
    )


def error_response(method, code, message="Fail"):
    r = {
        "Method": str(method),
        "Status": str(code),
        "Message": str(message) if message else "",
    }

    return Response(
        json.dumps(r, ensure_ascii=False, sort_keys=False, indent=4), mimetype="application/json"
    )
