from flask import request
from sqlalchemy.exc import SQLAlchemyError
from ..models import Device, SceneMode, User, scene_devices, db


def smart_plug_scene():
    if request.method == "POST":
        method = request.form.get("Method")
        print(method)
        if method == "AddScene":
            scene_name = request.form.get("SceneName")
            home_id = request.form.get("HomeID")
            # 不确定如何传入list
            devices = request.form.getlist("Devices")
            new_scene = SceneMode.add_scene(scene_name, home_id)
            if not new_scene:
                return {"Method": str(method), "Status": "1", "Message": "添加失败请重试"}
            if not new_scene.add_devices(devices):
                return {"Method": str(method), "Status": "1", "Message": "设备信息添加失败，请重新操作"}
            return {"Method": str(method), "Status": "0", "Message": "success"}
        elif method == "EditScene":
            scene_id = request.form.get("SceneID")
            scene_name = request.form.get("SceneName")
            scene = SceneMode.query.filter_by(id=scene_id).first()
            if not scene:
                return {"Method": str(method), "Status": "1", "Message": "未找到情景模式"}
            try:
                scene.name = scene_name
                db.session.commit()
                return {"Method": str(method), "Status": "0", "Message": "success"}
            except SQLAlchemyError:
                db.session.rollback()
                return {"Method": str(method), "Status": "1", "Message": "场景名称修改失败"}
        elif method == "DeleteGroup":
            scene_id = request.form.get("SceneID")
            scene = SceneMode.query.filter_by(id=scene_id).first()
            if not scene:
                return {"Method": str(method), "Status": "1", "Message": "未找到情景模式"}
            try:
                db.session.delete(scene)
                return {"Method": str(method), "Status": "0", "Message": "success"}
            except SQLAlchemyError:
                db.session.rollback()
                return {"Method": str(method), "Status": "1", "Message": "删除失败"}
        elif method == "AddSceneDevice":
            scene_id = request.form.get("SceneID")
            device_id = request.form.get("DeviceID")
            status = request.form.get("Command")
            if (scene_id and str(scene_id).isnumeric()) and \
                    (device_id and str(device_id).isnumeric()):
                rel_sql = scene_devices.insert().values(device_id=device_id, groupdev_id=scene_id, device_status=status)
                try:
                    db.session.execute(rel_sql)
                    db.session.commit()
                    return {"Method": str(method), "Status": "0", "Message": "success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": str(method), "Status": "1", "Message": "设备添加失败"}
            return {"Method": str(method), "Status": "1", "Message": "参数错误"}
        elif method == "ModifySceneDevice":
            scene_id = request.form.get("SceneID")
            device_id = request.form.get("DeviceID")
            status = request.form.get("Command")
            if (scene_id and str(scene_id).isnumeric()) and (device_id and str(device_id).isnumeric()):
                rel_sql = scene_devices.update().where(
                    scene_devices.c.device_id == device_id, scene_devices.c.scene_id == scene_id
                ).values(device_status=status)
                try:
                    db.session.execute(rel_sql)
                    db.session.commit()
                    return {"Method": str(method), "Status": "0", "Message": "修改成功"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": str(method), "Status": "1", "Message": "修改失败"}
            return {"Method": str(method), "Status": "1", "Message": "参数错误"}

            pass
        elif method == "DeleteSceneDevice":
            scene_id = request.form.get("SceneID")
            device_id = request.form.get("DeviceID")
            if (scene_id and str(scene_id).isnumeric()) and (device_id and str(device_id).isnumeric()):
                rel_sql = scene_devices.delete().where(
                    scene_devices.c.device_id == device_id, scene_devices.c.scene_id == scene_id)
                try:
                    db.session.execute(rel_sql)
                    db.session.commit()
                    return {"Method": str(method), "Status": "0", "Message": "Success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": str(method), "Status": "1", "Message": "删除失败"}
            return {"Method": str(method), "Status": "1", "Message": "参数错误"}
        else:
            return {"Method": str(method), "Status": "1", "Message": "Check Method"}
    elif request.method == "GET":
        method = request.args.get("Method")
        print(method)
        if method == "GetHomeScene":
            pass
        else:
            return {"Method": str(method), "Status": "1", "Message": "Check Method"}

