from flask import request
from sqlalchemy.exc import SQLAlchemyError
from .utils import redirect_request, success_response, error_response
from .home_service import *
from ..models import User, Home, user_homes, db, Message, HomeSharing, DeviceSharing, shared_devices


def smart_plug_home():
    if request.method == "POST":
        method = request.form.get("Method")
        print(method)
        if method == "AddHome":
            username = request.form.get("Usr")
            home_name = request.form.get("HomeName")
            longitude = request.form.get("Longitude")
            latitude = request.form.get("Latitude")
            location_name = request.form.get("HomePosition")
            user = User.query.filter_by(username=username).first()
            if user:
                home_info = {
                    "nickname": home_name,
                    "create_user": user.id,
                    "longitude": longitude,
                    "latitude": latitude,
                    "location_name": location_name,
                }
                h = Home.create_home(user.id, **home_info)
                if h:
                    return success_response(method, 0, str(h.id))
                return error_response(method, 1, "家庭创建失败")
            return error_response(method, 1, "未找到用户")
        elif method == "AddRoom":
            home_id = request.form.get("HomeID")
            username = request.form.get("Usr")
            room_name = request.form.get("RoomName")
            if check_user_home_permission(home_id, username) < Home.HOME_USER:
                r = Room.create_room(room_name, home_id)
                if r:
                    return success_response(method, 0, str(r.id))
                return error_response(method, 1, "房间创建失败")
            return error_response(method, 1, "验证失败")
        elif method == "EditHomeName":
            username = request.form.get("Usr")
            home_name = request.form.get("HomeName")
            home_id = request.form.get("HomeID")
            if check_user_home_permission(home_id, username) < Home.HOME_USER:
                # 是当前用户下的home
                h = Home.query.filter_by(id=home_id).first()
                try:
                    h.nickname = home_name
                    db.session.commit()
                    return success_response(method, 0)
                except SQLAlchemyError:
                    db.session.rollback()
                    return error_response(method, 1, "修改失败")
            return error_response(method, 1, "验证失败")
        elif method == "EditRoomName":
            username = request.form.get("Usr")
            room_name = request.form.get("RoomName")
            room_id = request.form.get("RoomID")
            r = Room.query.filter_by(id=room_id).first()
            if r:
                if check_user_home_permission(r.home_id, username) < Home.HOME_USER:
                    r.nickname = room_name
                    try:
                        db.session.commit()
                        return success_response(method, 0)
                    except SQLAlchemyError:
                        db.session.rollback()
                        return error_response(method, 1, "修改失败")
                return error_response(method, 1, "验证失败")
            return error_response(method, 1, "未找到房间")
        elif method == "EditHomeLocation":
            longitude = request.form.get("Longitude")
            latitude = request.form.get("Latitude")
            location_name = request.form.get("HomePosition")
            home_id = request.form.get("HomeID")
            username = request.form.get("Usr")
            if check_user_home_permission(home_id, username) < Home.HOME_USER:
                # 是当前用户下的home
                h = Home.query.filter_by(id=home_id).first()
                try:
                    h.longitude = longitude
                    h.latitude = latitude
                    h.location_name = location_name
                    db.session.commit()
                    return success_response(method, 0)
                except SQLAlchemyError:
                    db.session.rollback()
                    return error_response(method, 1, "修改失败")
            return error_response(method, 1, "验证失败")
        elif method == "DeleteHome":
            # 删除房间 判断房间下设备
            home_id = request.form.get("HomeID")
            username = request.form.get("Usr")
            if check_user_home_permission(home_id, username) == Home.HOME_OWNER:
                h = Home.query.filter_by(id=home_id).first()
                if not check_home_device(h) and not check_home_exist_user(h):
                    del_statement = user_homes.delete().where(user_homes.c.home_id == h.id)
                    rooms = Room.query.filter_by(home_id=h.id).all()
                    try:
                        # 删除家庭
                        db.session.delete(h)
                        # 删除room
                        for r in rooms:
                            db.session.delete(r)
                        # 删除 user_homes
                        db.session.execute(del_statement)
                        db.session.commit()
                        return success_response(method, 0)
                    except SQLAlchemyError:
                        db.session.rollback()
                        return error_response(method, 1, "删除失败")
                return error_response(method, 1, "家庭下仍有设备或成员， 无法删除")
            return error_response(method, 1, "验证失败")
        elif method == "DeleteRoom":
            room_id = request.form.get("RoomID")
            username = request.form.get("Usr")
            r = Room.query.filter_by(id=room_id, room_type=Room.OTHER_ROOM).first()
            if r:
                if check_user_home_permission(r.home_id, username) < Home.HOME_USER:
                    default_room = Room.query.filter_by(home_id=r.home_id, room_type=Room.DEFAULT_ROOM).first()
                    d_id = default_room.id if default_room else None
                    devices = Device.query.filter_by(room_id=r.id).all()
                    try:
                        # 删除
                        db.session.delete(r)
                        # 房间下设备回到全屋
                        for d in devices:
                            d.room_id = d_id
                        db.session.commit()
                        return success_response(method, 0)
                    except SQLAlchemyError:
                        db.session.rollback()
                        return error_response(method, 1, "删除失败")
                return error_response(method, 1, "验证失败")
            return error_response(method, 1, "未找到房间")

        elif method == "ShareHome":
            home_id = request.form.get("HomeID")
            username = request.form.get("Usr")
            share_to_user_name = request.form.get("ShareTo")
            permission = request.form.get("Permission")
            user_shared_to = User.check_user_exist(value=share_to_user_name)
            user_shared_from = User.check_user_exist(value=username)
            if not user_shared_to or not user_shared_from:
                return error_response(method, 1, "用户名不存在")
            if check_user_home_permission(home_id, username) == Home.HOME_OWNER:
                home = Home.query.filter_by(id=home_id).first()
                context = "{}向您分享家庭{}".format(username, home.nickname)
                p = Home.HOME_ADMIN if permission == "Admin" else Home.HOME_USER
                # 存储消息并推送。
                share = HomeSharing.create_share(home.id, user_shared_from.id, user_shared_to.id, p)
                if share:
                    Message.add_message(
                        receiver_id=user_shared_to.id, title="家庭分享", context=context, message_type=Message.SYSTEM_MSG,
                        ext_data=str(share.id)
                    )
                    # 信息推送代码 待实现
                    # ...
                    return success_response(method, 0)
                return error_response(method, 1, "分享失败")
            return error_response(method, 1, "验证失败")
        elif method == "ConfirmHomeShare":
            # home_id = request.form.get("HomeID")
            # username = request.form.get("Usr")
            # share_to_user = User.check_user_exist(value=username)
            # s = HomeSharing.query.filter_by(home_id=home_id, share_to=share_to_user.id).first()
            home_share_id = request.form.get("SharedID")
            s = HomeSharing.query.filter_by(id=home_share_id).first()
            if s:
                try:
                    rel_sql = user_homes.insert().values(home_id=s.home_id, user_id=s.share_to, permission=s.permission)
                    db.session.execute(rel_sql)
                    # 删除sharing 添加user_homes
                    db.session.delete(s)
                    db.session.commit()
                    return success_response(method, 0)
                except SQLAlchemyError:
                    db.session.rollback()
                    return error_response(method, 1, "确认失败")
            return error_response(method, 1, "未找到记录")
        elif method == "ShareDevice":
            # 设备所属家庭权限
            username = request.form.get("Usr")
            device_ids = request.form.get("Devices")
            share_to = request.form.get("ShareTo")
            share_to_user = User.check_user_exist(value=share_to)
            share_from_user = User.check_user_exist(value=username)
            if not share_to_user or not share_from_user:
                return error_response(method, 1, "未找到用户")

            for device_id in eval(device_ids):
                new_share = DeviceSharing.create_share(device_id, share_from_user.id, share_to_user.id)
                if new_share:
                    device = Device.query.filter_by(id=device_id).first()
                    context = "{}向您分享设备{}".format(username, device.name)
                    Message.add_message(
                        receiver_id=share_to_user.id, title="设备分享", context=context, message_type=Message.SYSTEM_MSG,
                        ext_data=str(new_share.id)
                    )
                    # 信息推送代码 待实现
                    # ...
            return success_response(method, 0)
        elif method == "ConfirmDeviceShare":
            device_ids = request.form.get("Devices")
            share_to = request.form.get("Usr")
            user_share_to = User.check_user_exist(value=share_to)

            for i in eval(device_ids):
                device = Device.query.filter_by(id=i).first()
                home = Home.query.filter_by(id=device.home_id).first()
                s = DeviceSharing.query.filter_by(device_id=i, share_to=share_to, share_from=home.create_user).first()
                try:
                    if not db.query(shared_devices).filter(
                            shared_devices.c.device_id == i, shared_devices.c.share_to == user_share_to.id):
                        rel_sql = shared_devices.insert().values(
                            device_id=i, share_from=home.create_user, share_to=user_share_to.id)
                        db.session.execute(rel_sql)
                    # 删除sharing 添加user_homes
                    db.session.delete(s)
                    db.session.commit()
                except SQLAlchemyError:
                    db.session.rollback()
            return success_response(method, 0)
        elif method == "ConfirmDeviceShare_":
            device_share_id = request.form.get("SharedID")
            s = DeviceSharing.query.filter_by(id=device_share_id).first()
            if s:
                try:
                    if not db.query(shared_devices).filter(
                            shared_devices.c.device_id == s.device_id, shared_devices.c.share_to == s.share_to):
                        rel_sql = shared_devices.insert().values(
                            device_id=s.device_id, share_from=s.share_from, share_to=s.share_to)
                        db.session.execute(rel_sql)
                    # 删除sharing 添加user_homes
                    db.session.delete(s)
                    db.session.commit()
                    return success_response(method, 0)
                except SQLAlchemyError:
                    db.session.rollback()
                    return error_response(method, 1, "确认失败")
            return error_response(method, 1, "未找到记录")
        elif method == "RemoveDeviceShare":
            username = request.form.get("ShareTo")
            device_ids = request.form.get("Devices")

            user = User.check_user_exist(value=username)
            if not user:
                return error_response(method, 1, "未找到用户")

            del_sat = shared_devices.delete().where(
                shared_devices.c.device_id.in_(eval(device_ids)), shared_devices.c.share_to == user.id)
            try:
                db.session.execute(del_sat)
                db.session.commit()
                return success_response(method, 0)
            except SQLAlchemyError:
                return error_response(method, 1, "移除失败")
        elif method == "RemoveHomeShare":
            home_id = request.form.get("HomeID")
            username = request.form.get("ShareTo")

            user = User.check_user_exist(value=username)
            if not user:
                return error_response(method, 1, "未找到用户")
            del_sat = user_homes.delete().where(
                user_homes.c.home_id == home_id, user_homes.c.user_id == user.id)
            try:
                db.session.execute(del_sat)
                db.session.commit()
                return success_response(method, 0)
            except SQLAlchemyError:
                return error_response(method, 1, "停止共享失败")

        elif method == "EditRoomDevice":
            device_ids = request.form.get("Devices")
            new_room_id = request.form.get("RoomID")
            new_room = Room.query.filter_by(id=new_room_id).first()
            if new_room and device_ids:
                devices = Device.query.filter(Device.id.in_(eval(device_ids))).all()
                try:
                    for device in devices:
                        device.room_id = new_room.id
                    db.session.commit()
                    return {"Method": method, "Status": "0", "Message": "success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": method, "Status": "1", "Message": "修改失败，请重试"}
            return {"Method": method, "Status": "1", "Message": "参数有误，请核对"}

        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlugHome/")
            if status_code == 200:
                return text
            return error_response(method, 1, "Check Method")
    elif request.method == "GET":
        method = request.args.get("Method")
        print(method)
        if method == "GetHomeList":
            username = request.args.get("Usr")
            homes = get_user_homes(username)
            for i in range(len(homes)):
                room = get_home_rooms(homes[i].get("HomeID"))
                homes[i]["Room"] = room
            return success_response(method, 0, homes)
        elif method == "GetRoomDevices":
            # 并不包含device status信息
            room_id = request.args.get("RoomID")
            r = get_room_devices(room_id)
            return success_response(method, 0, r)
        elif method == "GetHomeDevices":
            home_id = request.args.get("HomeID")
            r = get_home_devices(home_id)
            return success_response(method, 0, r)
        elif method == "GetUserDevices":
            username = request.args.get("Usr")
            user = User.check_user_exist(value=username)
            if user:
                r = get_user_devices(user.id)
                return success_response(method, 0, data=r)
            return error_response(method, 1, "用户不存在")
        elif method == "GetHomeSharingList":
            username = request.args.get("Usr")

            r = []
            u = User.check_user_exist(value=username)
            if not u:
                return error_response(method, 1, "未找到用户")
            shares = HomeSharing.query.filter_by(share_to=u.id).all()
            for share in shares:
                share_from_user = User.query.filter_by(id=share.user_id).first()
                home = Home.query.filter_by(id=share.home_id).first()
                r.append({
                    "ShareID": share.id,
                    "ShareFrom": share_from_user.username,
                    "HomeName": home.nickname
                })
            return success_response(method, 0, data=r)
        elif method == "GetHomeSharedList":
            username = request.args.get("Usr")
            home_id = request.args.get("HomeID")

            user = User.check_user_exist(value=username)
            home = Home.query.filter_by(id=home_id).first()
            r = []
            if not user or not home:
                return error_response(method, 1, "参数错误")
            u_homes = db.session.query(user_homes).filter_by(home_id=home.id).filter(
                user_homes.c.permission != Home.HOME_OWNER, user_homes.c.user_id != user.id).all()
            for u in u_homes:
                user = User.query.filter_by(id=u.id).first()
                r.append({
                    "Usr": user.username,
                    "Nickname": user.nickname,
                    "Permission": "Admin" if u.permission == Home.HOME_ADMIN else "User"
                })
            return success_response(method, 0, data=r)
        elif method == "GetDeviceSharingList":
            username = request.args.get("Usr")

            u = User.check_user_exist(value=username)
            r = []
            if not u:
                return error_response(method, 1, "未找到用户")
            shares = DeviceSharing.query.filter_by(share_to=u.id).all()
            for share in shares:
                share_from_user = User.query.filter_by(id=share.user_id).first()
                device = Device.query.filter_by(id=share.device_id).fisrt()
                r.append({
                    "ShareID": share.id,
                    "ShareFrom": share_from_user.username,
                    "DeviceName": device.name
                })
            return success_response(method, 0, data=r)
        elif method == "GetDeviceSharedList":
            username = request.args.get("Usr")
            device_id = request.args.get("DeviceID")

            r = []
            user = User.check_user_exist(value=username)
            device = Device.query.filter_by(id=device_id).first()
            if not user or not device:
                return error_response(method, 1, "参数错误")
            shares = db.session.query(shared_devices).filter_by(device_id=device.id, share_from=user.id).all()
            for share in shares:
                user = User.query.filter_by(id=share.share_to).first()
                r.append({
                    "Usr": user.username,
                    "Nickname": user.nickname,
                })
            return success_response(method, 0, data=r)
        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlugHome/")
            if status_code == 200:
                return text
            return {"Method": str(method), "Status": "1", "Message": "check method"}
