from flask import request

from .device_group import *
from ..models import Device, device_groups, GroupDev, User, db
from sqlalchemy.exc import SQLAlchemyError


def smart_plug_group():
    if request.method == "POST":
        method = request.form.get("Method")
        print(method)
        if method == "AddGroup":
            group_name = request.form.get("GroupName")
            user_nickname = request.form.get("Usr")
            user = User.check_user_exist(value=user_nickname)
            if not user:
                return {"Method": str(method), "Status": "1", "Message": "未找到用户"}
            new_group_dev = GroupDev.add_group_dev(group_name, user.id)
            if not new_group_dev:
                return {"Method": str(method), "Status": "1", "Message": "添加失败，请重试"}
            return {"Method": str(method), "Status": "0", "Message": "success"}
        elif method == "EditGroup":
            group_id = request.form.get("group_id")
            group_name = request.form.get("group_name")
            group_dev = GroupDev.query.filter_by(id=group_id).first()
            if not group_dev:
                return {"Method": str(method), "Status": "1", "Message": "未找到分组"}
            try:
                group_dev.nickname = group_name
                db.session.commit()
                return {"Method": str(method), "Status": "0", "Message": "success"}
            except SQLAlchemyError:
                db.session.rollback()
                return {"Method": str(method), "Status": "1", "Message": "分组名称修改失败"}
        elif method == "DeleteGroup":
            group_id = request.form.get("GroupID")
            group_dev = GroupDev.query.filter_by(id=group_id).first()
            if not group_dev:
                return {"Method": str(method), "Status": "1", "Message": "未找到分组"}
            try:
                db.session.delete(group_dev)
                return {"Method": str(method), "Status": "0", "Message": "success"}
            except SQLAlchemyError:
                db.session.rollback()
                return {"Method": str(method), "Status": "1", "Message": "未找到分组"}
        elif method == "AddGroupDevice":
            group_id = request.form.get("GroupID")
            device_id = request.form.get("DeviceID")
            if (group_id and str(group_id).isnumeric()) and \
                    (device_id and str(device_id).isnumeric()):
                rel_sql = device_groups.insert().values(device_id=device_id, groupdev_id=group_id)
                try:
                    db.session.execute(rel_sql)
                    db.session.commit()
                    return {"Method": str(method), "Status": "0", "Message": "success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": str(method), "Status": "1", "Message": "添加失败"}
            return {"Method": str(method), "Status": "1", "Message": "参数错误"}
        elif method == "DeleteGroupDevice":
            group_id = request.form.get("GroupID")
            device_id = request.form.get("DeviceID")
            if (group_id and str(group_id).isnumeric()) and \
                    (device_id and str(device_id).isnumeric()):
                rel_sql = device_groups.delete().where(
                    device_groups.c.device_id == device_id, device_groups.c.groupdev_id == group_id)
                try:
                    db.session.execute(rel_sql)
                    db.session.commit()
                    return {"Method": str(method), "Status": "0", "Message": "success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": str(method), "Status": "1", "Message": "删除失败"}
            return {"Method": str(method), "Status": "1", "Message": "参数错误"}
        else:
            return {"Method": str(method), "Status": "1", "Message": "Check Method"}
    elif request.method == "GET":
        method = request.args.get("Method")
        print(method)
        if method == "GetUserGroup":
            username = request.args.get("Usr")
            groups = get_user_group_dev(username)
            for group in groups:
                group["Device"] = get_group_device(group["GroupID"])
            return {"Method": str(method), "Status": "0", "Data":groups, "Message": "success"}
        else:
            return {"Method": str(method), "Status": "1", "Message": "Check Method"}
