

from flask import Blueprint, request, session, url_for, jsonify

from flask_jwt_extended import (create_access_token, get_jwt_identity, jwt_required,
                                JWTManager, current_user)
from sqlalchemy.exc import SQLAlchemyError
from ..qq.routes import qq_login
from ..models import Message
from ..home.validation import register_user_valid
from .home_service import *
from .message_service import *
from .utils import *
from .smartplug_scene_route import smart_plug_scene
from .smartplug_home_route import smart_plug_home
from .smartplug_data_route import smart_plug_data
from .smartplug_group_route import smart_plug_group


bp = Blueprint("home", __name__)
jwt = JWTManager()

bp.add_url_rule("/SmartPlugData/", "data_route", smart_plug_data, methods=["POST", "GET"])
bp.add_url_rule("/SmartPlugScene/", "scene_route", smart_plug_scene, methods=["POST", "GET"])
bp.add_url_rule("/SmartPlugHome/", "home_route", smart_plug_home, methods=["POST", "GET"])
bp.add_url_rule("/SmartPlugGroup/", "group_route", smart_plug_group, methods=["POST", "GET"])


# 消息接口
@bp.route("/SmartPlugMessage/", methods=['GET'])
def smart_plug_message():
    if request.method == "POST":
        method = request.form.get('Method')
        return error_response(method, 1, "Method Error")
    else:
        method = request.args.get("Method")
        if method == "GetMessage":
            username = request.args.get("Usr")
            last_id = request.args.get("LastID")
            t = request.args.get("MsgType")
            messages = get_user_messages(username=username, last_id=last_id, msg_type=t)
            return success_response(method, 0, data=messages)
        return error_response(method, 1, "Method Error")


# 登录
@bp.route("/SmartPlugUsr/", methods=['POST', 'GET'])
def smart_plug_usr():
    if request.method == "POST":
        method = request.form.get("Method")
        print(method)
        if method == "QQLogin":
            token = request.form.get("QQToken")
            r = qq_login(token)
            if r["code"] == 0:
                # success
                return {"QQUser": r["username"], "QQPwd": r["password"]}
            else:
                return {"Method": "QQLogin", "Status": "1", "Message": r.get("message")}
        elif method == "UploadPhone":
            user_flag = request.form.get("ContactWay")
            if "@" in user_flag:
                r = mail_send(user_flag)
            else:
                r = sms_send(user_flag)
            if r["code"] == 0:
                # success
                return {"Method": method, "Status": "0"}
            else:
                return {"Method": method, "Status": "1", "Message": r.get("message", "")}

        elif method == "SmsVerification":
            code = request.form.get("VerCode")
            phone = request.form.get("PhoneNumber")

            r = code_login(phone, code)

            if r["code"] == 0:
                # success
                r = {"Method": method, "User": r["username"], "Pwd": r["password"], "Status": "0"}
                return r
            else:
                r = {"Method": method, "Status": "1", "Message": r.get("message", "")}
                return r
        elif method == "ConfirmationCode":
            code = request.form.get("AuthCode")
            key = request.form.get("ContactWay")
            if verify_code_result(key, code):
                return {"Method": method, "Message": "SUCCESS", "Status": "0"}
            return {"Method": method, "Message": "验证码验证失败", "Status": "1"}
        elif method == "UpPwd":
            username = request.form.get("Usr")
            new_pwd = request.form.get("NewPwd")
            user = User.query.filter_by(username=username).first()
            if not user:
                return {"Method": method, "Status": "1", "Message": "用户不存在"}
            if user.change_password(new_pwd):
                return {"Method": method, "Status": "0", "Message": "success"}
            return {"Method": method, "Status": "1", "Message": "修改失败，请重试"}

        elif method == "ForgotPassword":
            user_flag = request.form.get("ContactWay")
            password = request.form.get("Password")
            if "@" in user_flag:
                user = User.check_user_exist(key="email", value=user_flag)
            else:
                user = User.check_user_exist(key="cellphone", value=user_flag)
            if not user:
                return {"Method": method, "Status": "1", "Message": "用户不存在 "}
            if user.change_password(password):
                return {"Method": method, "Status": "0", "Message": "success"}
            return {"Method": method, "Status": "1", "Message": "修改失败，请重试"}

        elif method == "VMPhoneNumber":
            user_flag = request.form.get("ContactWay")
            if "@" in user_flag:
                user = User.check_user_exist(key="email", value=user_flag)
            else:
                user = User.check_user_exist(key="cellphone", value=user_flag)

            if user:
                # 有用户
                return {"Method": method, "Status": "0", "Message": ""}

            return {"Method": method, "Status": "1", "Message": "未找到用户"}

        elif method == "ModifyingInformation":
            username = request.form.get("Usr")
            user = User.query.filter_by(username=username).first()
            if not user:
                return {"Method": method, "Status": "1", "Message": "用户不存在"}
            modify_dict = {}
            for i in ["userIcon", "userPhone", "userEmail", "nickName"]:
                if request.form.get(i):
                    modify_dict[i] = request.form.get(i)
            if modify_dict.get("userPhone") and \
                    User.check_user_exist("cellphone", modify_dict.get("userPhone")):
                return {"Method": method, "Status": "1", "Message": "手机号已注册"}

            if modify_dict.get("userEmail") and \
                    User.check_user_exist("email", modify_dict.get("userEmail")):
                return {"Method": method, "Status": "1", "Message": "邮箱已注册"}

            for k, v in modify_dict.items():
                if k == "userIcon":
                    user.usericon = v
                if k == "userPhone":
                    user.cellphone = v
                if k == "userEmail":
                    user.email = v
                if k == "nickName":
                    user.nickname = v
            try:
                db.session.commit()
                return {"Method": method, "Status": "0", "Message": "success"}
            except Exception as e:
                db.session.rollback()
                return {"Method": method, "Status": "1", "Message": "DataBase Error: {}".format(e)}

        elif method == "RegistUsr":
            username = request.form.get("Usr")
            cellphone = request.form.get("Phone")
            email = request.form.get("Email")
            password = request.form.get("Pwd")

            username_exist = User.check_user_exist(value=username)
            phone_exist = User.check_user_exist(key="cellphone", value=cellphone)
            email_exist = User.check_user_exist(key="email", value=email)
            if username_exist:
                return error_response(method, 1, "用户名已存在")
            if phone_exist:
                return error_response(method, 1, "手机号已注册")
            if email_exist:
                return error_response(method, 1, "邮箱已注册")

            new_user = User.create_user(username=username, email=email, cellphone=cellphone, password=password)
            if new_user:
                return success_response(method, 0, data={"Usr":username, "Pwd": password})
            return error_response(method, 1, "注册失败")

        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlugUsr/")
            if status_code == 200:
                return text
            return {"Method": str(method), "Status": '1', "Message": "check method"}
    else:
        method = request.args.get("Method")
        print(method)
        if method == "GetInformation":
            username = request.args.get("Usr")
            user = User.query.filter_by(username=username).first()
            if user:
                return {"Method": method,
                        "Usr": user.username if user.username else "",
                        "userEmail": user.email if user.email else "",
                        "userPhone": user.cellphone if user.cellphone else "",
                        "nickName": user.nickname if user.nickname else "",
                        "userIcon": user.usericon if user.usericon else "", "Status": "0"}
            return {"Method": method, "Status": '1', "Message": "user not found"}
        if method == "CheckUserExist":
            username = request.args.get("Usr")
            if User.query.filter_by(username=username).first():
                return success_response(method, 0)
            return error_response(method, 1, "未找到用户")
        elif method == "Login":
            username = request.args.get("Usr")
            password = request.args.get("Pwd")
            device_token = request.args.get("DeviceTocken")

            user = User.check_user_exist(key='username', value=username) or \
                User.check_user_exist(key='cellphone', value=username)
            if user:
                # 验证密码
                if user.check_password(password):
                    return {"Method": method, "Status": '0', "Message": "success"}
                return {"Method": method, "Status": '1', "Message": "密码验证失败"}

            return {"Method": method, "Status": '1', "Message": "未找到用户"}
        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlugUsr/")
            if status_code == 200:
                return text
            return {"Method": str(method), "Status": '1', "Message": "check method"}


@bp.route("/SmartPlug/", methods=["POST", "GET"])
def smart_plug():
    if request.method == "POST":
        method = request.form.get("Method")
        print(method)
        if method == "AddDevice":
            device_mac = request.form.get("DeviceID")
            device_name = request.form.get("DeviceName")
            home_id = request.form.get("HomeID")
            room_id = request.form.get("RoomID")
            electric_type = request.form.get("ElectricType")
            electric_brand = request.form.get("ElectricBrand")
            electric_model = request.form.get("ElectricModel")

            room = Room.query.filter_by(id=room_id, home_id=home_id).first()
            if not room:
                return {"Method": method, "Status": "1", "Message": "未找到对应家庭房间"}
            new_device = Device.add_device(device_mac, device_name, home_id, room_id)
            if not new_device:
                return {"Method": method, "Status": "1", "Message": "设备添加失败"}
            if new_device.bind_appliance(electric_type, electric_brand, electric_model):
                return {"Method": method, "Status": "0", "Message": "success"}
            return {"Method": method, "Status": "0", "Message": "电器绑定失败，请重新设置"}
        elif method == "RenameDevice":
            device_id = request.form.get("DeviceID")
            device_name = request.form.get("DeviceName")
            room_id = request.form.get("RoomID")

            device = Device.query.filter_by(id=device_id, room_id=room_id).first()
            if device:
                try:
                    device.name = device_name
                    db.session.commit()
                    return {"Method": method, "Status": "1", "Message": "success"}
                except SQLAlchemyError:
                    db.session.rollback()
                    return {"Method": method, "Status": "0", "Message": "修改失败，请重试"}
            return {"Method": method, "Status": "0", "Message": "未找到对应设备"}
        elif method == "DeleteDevice_":
            device_id = request.form.get("DeviceID")
            room_id = request.form.get("RoomID")
            room = Room.query.filter_by(id=room_id).first()
            if room:
                device = Device.query.filter_by(id=device_id, room_id=room.id).first()
                if device:
                    try:
                        db.session.delete(device)
                        db.session.commit()
                        return {"Method": method, "Status": "1", "Message": "success"}
                    except SQLAlchemyError:
                        db.session.rollback()
                        return {"Method": method, "Status": "0", "Message": "删除失败，请重试"}
                return {"Method": method, "Status": "0", "Message": "未找到对应设备"}
            return {"Method": method, "Status": "0", "Message": "未找到对应房间"}
        elif method == "ModifyElectrical_":
            username = request.form.get("Usr")
            device_id = request.form.get("DeviceID")
            electric_type = request.form.get("ElectricType")
            electric_brand = request.form.get("ElectricBrand")
            electric_model = request.form.get("ElectricModel")
            user = User.query.filter_by(username=username).first()
            if user:
                device = user.check_user_device(device_id)
                if device:
                    if device.bind_appliance(electric_type, electric_brand, electric_model):
                        return {"Method": method, "Status": "1", "Message": "success"}
                    return {"Method": method, "Status": "0", "Message": "修改失败"}
                return {"Method": method, "Status": "0", "Message": "未找到设备"}
            return {"Method": method, "Status": "0", "Message": "未找到用户"}
        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlug/")
            if status_code == 200:
                return text
            return {"Method": str(method), "Status": "1", "Message": "check method"}
    elif request.method == "GET":
        method = request.args.get("Method")
        print(method)
        if method == "":
            pass
        else:
            # 获取旧api
            text, status_code = redirect_request(request, "SmartPlug/")
            if status_code == 200:
                return text
            return {"Method": str(method), "Status": "1", "Message": "check method"}


# 验证码登录
def code_login(phone, code):
    if verify_code_result(phone, code):
        # 验证成功, 判断是否有此手机号的账号
        # 有账号返回账号信息， 无账号 以手机号为用户民注册
        user = User.check_user_exist(key='cellphone', value=phone)
        if not user:
            # 注册 或 返回未找到用户信息
            pwd = rand_password()
            user = User.create_user(username=phone[-11:], password=pwd, cellphone=phone)

        return {"code": 0, "username": user.username, "password": user.password, "message": "login success"}

    # 验证码验证失败
    return {"code": -3, "result": 'fail', 'message': 'code verify fail'}


# create_access_token 默认加载的 identity
@jwt.user_identity_loader
def user_identity_loader(user):
    return user.id


# 返回查询User
@jwt.user_lookup_loader
def user_lookup_callback(_jwt_header, jwt_data):
    identity = jwt_data["sub"]
    return User.query.filter_by(id=identity).first()


@bp.route("/protected-path", methods=["GET"])
@jwt_required()
def test():
    print(current_user)
    return current_user.username


# 注册信息
@bp.route("/register", methods=["POST"])
def register():
    register_data = request.json
    # validation
    valid_data, errors = register_user_valid(register)

    if valid_data:
        # 验证成功
        user = User.create_user(**valid_data)
        if user:
            # 注册成功
            return {"code": 1, "username": user.username, "password": user.password, "mesage": "success"}

        # 失败
        return {"code": -1, "result": "fail", "message": "reg server error"}

    # 验证失败信息
    return {"code": -1, "result": "fail", "message": "register valid error", "errors": errors}
