from ..models import Message, User
import datetime


def get_user_messages(username, limit: int = 20, msg_type=None, last_id=None):
    result = []
    user = User.check_user_exist(value=username)
    if user:
        messages = Message.query.filter_by(receiver_id=user.id)
        if msg_type:
            if msg_type == "SYS":
                t = Message.SYSTEM_MSG
            else:
                t = Message.DEVICE_MSG
            messages = messages.filter_by(message_type=t)
        if last_id:
            messages = messages.filter(Message.id <= last_id)
        messages = messages.order_by(Message.id.desc()).limit(limit)
        for msg in messages:
            result.append({
                "MessageID": msg.id,
                "Title": msg.title,
                "Context": msg.context,
                "MessageType": "系统消息" if msg.message_type == Message.SYSTEM_MSG else "设备消息",
                "IsRead": "TRUE" if msg.is_read else "FALSE",
                "ExtData": msg.ext_data if msg.ext_data else "",
                "CreateAt": msg.create_time.strftime("%Y-%m-%d %H:%M:%S")
            })
    return result
