# home 以及 room相关服务
from ..models import Home, Room, User, user_homes, db, Device, shared_devices


def get_user_homes(username):
    """
    获取当前用户名下的所有家庭ID
    :param username:
    :return:
        [{"HomeID": "", "HomeName":""},{...}]
    """
    user = User.query.filter_by(username=username).first()
    result = []
    if user:
        u_homes = db.session.query(user_homes).filter_by(user_id=user.id).all()
        home_id_filter = []
        for h in u_homes:
            home_id_filter.append(h.home_id)

        homes = Home.query.filter(Home.id.in_(home_id_filter)).all()
        for home in homes:
            result.append(
                {
                    "HomeID": str(home.id),
                    "Longitude": home.longitude if home.longitude else "",
                    "Latitude": home.latitude if home.latitude else "",
                    "HomePosition": home.location_name if home.location_name else "",
                    "HomeName": home.nickname,
                }
            )
    return result


def get_home_rooms(home_id):
    """
    通过家庭id获取家庭下的所有房间
    :param home_id: 家庭id
    :return:
    """
    rooms = Room.query.filter_by(home_id=home_id).all()
    result = []
    for room in rooms:
        result.append(
            {
                "RoomID": str(room.id),
                "RoomName": room.nickname,
                "Device": get_room_devices(room.id)
            }
        )
    return result


def get_user_devices(user_id):
    """
    获取用户的所有设备
    :param user_id:
    :return:
    """
    r = []
    homes = Home.query.filter_by(create_user=user_id).all()
    for home in homes:
        r = r + get_home_devices(home.id)
    return r


def get_room_devices(room_id):
    """
    获取当前房间下的所有设备
    :param room_id:
    :return:
    """
    room = Room.query.filter_by(id=room_id).first()
    home = Home.query.filter_by(id=room.home_id).first()
    home_name = home.nickname if home else "None"
    if room and room.room_type == Room.DEFAULT_ROOM:
        devices = Device.query.filter_by(home_id=room.home_id).all()
    else:
        devices = Device.query.filter_by(room_id=room_id).all()
    result = []
    for device in devices:
        result.append({
            "DeviceID": str(device.id),
            "DeviceName": device.name,
            "DeviceMac": device.mac,
            "IsOnline": device.is_online if device.is_online else "",
            "AccStatus": device.acc_status if device.acc_status else "",
            "HomeName": home_name,
            "IsShared": "True" if check_device_shared(device.id) else "False",
            "RoomName": room.nickname,
            "RoomID": str(room_id),
        })
    return result


def get_home_devices(home_id):
    r = []
    home = Home.query.filter_by(id=home_id).first()
    home_name = home.nickname if home else "None"
    devices = Device.query.filter_by(home_id=home_id).all()
    for device in devices:
        # 不建议
        room = Room.query.filter_by(id=device.room_id).first()
        r.append({
            "DeviceID": str(device.id),
            "DeviceName": device.name,
            "DeviceMac": device.mac,
            "IsOnline": device.is_online if device.is_online else "",
            "AccStatus": device.acc_status if device.acc_status else "",
            "IsShared": "True" if check_device_shared(device.id) else "False",
            "HomeName": home_name,
            "RoomName": room.nickname if room else " ",
            "RoomID": str(device.room_id),
        })
    return r


def check_user_home_permission(home_id, username):
    """
    判断用户对家庭的权限
    :param home_id: 家庭id
    :param username: 用户名 唯一
    :return:
    """
    home = Home.query.filter_by(id=home_id).first()
    if not home:
        return 1000
    user = User.check_user_exist(value=username)
    if not user:
        return 1001
    user_home = db.session.query(user_homes).filter_by(home_id=home.id, user_id=user.id).first()
    if not user_home:
        return 1002
    return user_home.permission


def check_home_exist_user(home: Home):
    """
    判断当前家庭下是否有创建者外的其他用户
    :param home:
    :return:
    """
    return db.session.query(user_homes).filter(
                    user_homes.c.home_id == home.id, user_homes.c.permission != Home.HOME_OWNER).first()


def check_home_device(home: Home):
    """
    判断当前家庭下是否有设备
    :param home:
    :return:
    """
    # 判断全屋下是否有设备即可
    default_room = Room.query.filter_by(home_id=home.id, room_type=Room.DEFAULT_ROOM).first()
    if not default_room:
        return None
    return Device.query.filter_by(room_id=default_room.id).first()


def check_user_device_permission(device_id, username):
    """
    判断用户的设备权限， 用户是否具有设备所在家庭的管理员权限
    :param device_id:
    :param username:
    :return:
    """
    device = Device.query.filter_by(id=device_id).first()
    if not device:
        return 1000
    return check_user_home_permission(device.home_id, username)


def check_device_shared(device_id):
    if db.session.query(shared_devices).filter(shared_devices.c.device_id==device_id).first():
        return True
    return False
