from ..models import Device, GroupDev, User, device_groups, db


def get_user_group_dev(username: str):
    """
    获取用户名下的所有设备组
    :param username: str 用户名
    :return: list
        [{"GroupID": "", "GroupName“: ""}]
    """
    user = User.query.filter_by(username=username).one_or_none()
    result = []
    if user:
        group_devs = GroupDev.query.filter_by(user_id=user.id).all()
        for group_dev in group_devs:
            result.append(
                {
                    "GroupID": group_dev.id,
                    "GroupName": group_dev.nickname,
                }
            )
    return result


def get_group_device(group_id):
    """
    获取设备组下的所有设备
    :param group_id: 设备组id
    :return:  list
        [{"DeviceID": mac, "DeviceName": name }]
    """
    groups = db.session.query(device_groups).filter_by(groupdev_id=group_id).all()
    result = []
    device_ids = []
    for group in groups:
        device_ids.append(group.device_id)

    devices = Device.query.filter(Device.id.in_(device_ids)).all()
    for device in devices:
        result.append({
            "DeviceID": device.id,
            "DeviceName": device.name
        })
    return result
