import time


class SnowflakeIDGenerator:
    """
    简化版生成器， 去除 work_id, datacenter_id, sequence 变为4位 最多64
    """
    def __init__(self, worker_id, datacenter_id):
        self.worker_id = worker_id
        self.datacenter_id = datacenter_id
        self.sequence = 0
        self.last_timestamp = -1

    def generate_id(self):
        timestamp = self._get_current_timestamp()

        if timestamp < self.last_timestamp:
            raise Exception("Invalid system clock")

        if timestamp == self.last_timestamp:
            self.sequence = (self.sequence + 1) & 4095
            if self.sequence == 0:
                timestamp = self._wait_next_millisecond(timestamp)
        else:
            self.sequence = 0

        self.last_timestamp = timestamp

        generated_id = (
            (timestamp << 22)
            | (self.datacenter_id << 17)
            | (self.worker_id << 12)
            | self.sequence
        )
        return generated_id

    @classmethod
    def _get_current_timestamp(cls):
        return int(time.time() * 1000)

    def _wait_next_millisecond(self, last_timestamp):
        timestamp = self._get_current_timestamp()
        while timestamp <= last_timestamp:
            timestamp = self._get_current_timestamp()
        return timestamp


class LiteGenerator:

    def __init__(self):
        self.sequence = 0
        self.last_timestamp = -1

    @classmethod
    def _get_current_timestamp(cls):
        return int(time.time()*1000)

    def _wait_next_millsecond(self, last_timestamp):
        timestamp = self._get_current_timestamp()
        while timestamp <= last_timestamp:
            timestamp = self._get_current_timestamp()
        return timestamp

    def generator_id(self):
        timestamp = self._get_current_timestamp()
        if timestamp < self.last_timestamp:
            raise Exception("Invalid system clock")

        if timestamp == self.last_timestamp:
            self.sequence = (self.sequence + 1) & 63    # 6位最大63
            if self.sequence == 0:
                timestamp = self._wait_next_millsecond()
        else:
            self.sequence = 0

        self.last_timestamp = timestamp

        generator_id = (
            (timestamp << 6)    # 左移sequence的位数
            | self.sequence
        )

        return generator_id


home_id_generator = LiteGenerator()
room_id_generator = LiteGenerator()
device_id_generator = LiteGenerator()
appliance_id_generator = LiteGenerator()
group_dev_id_generator = LiteGenerator()
scene_id_generator = LiteGenerator()
message_id_generator = LiteGenerator()
home_share_id_generator = LiteGenerator()
device_share_id_generator = LiteGenerator()

# 创建一个SnowflakeIDGenerator实例，传入worker_id和datacenter_id
if __name__ == "__main__":
    # id_generator = SnowflakeIDGenerator(worker_id=0, datacenter_id=0)
    # print(id_generator.generate_id())

    test_id = LiteGenerator()
    print(test_id.generator_id())
