import os
from flask import Flask
from website.models import db
from website.oauth2.oauth2 import config_oauth
from website.oauth2.routes import bp as oauth2_bp
from website.qq.routes import bp as qq_bp
from website.home.routes import bp
from website.home.routes import jwt


def create_app(config=None):
    app = Flask(__name__)

    # load default configuration
    app.config.from_object('website.settings')

    # load environment configuration
    if 'WEBSITE_CONF' in os.environ:
        app.config.from_envvar('WEBSITE_CONF')

    # load app specified configuration
    if config is not None:
        if isinstance(config, dict):
            app.config.update(config)
        elif config.endswith('.py'):
            app.config.from_pyfile(config)

    setup_app(app)
    return app


def setup_app(app):
    # Create tables if they do not exist already
    # @app.before_first_request
    def create_tables():
        db.create_all()

    db.init_app(app)
    jwt.init_app(app)
    config_oauth(app)
    app.register_blueprint(bp, url_prefix='')
    app.register_blueprint(oauth2_bp, url_prefix='/oauth2')
    app.register_blueprint(qq_bp, url_prefix='/qq')
