import os
import datetime
import logging
import json
from logging.handlers import RotatingFileHandler
from flask import request
from website.app import create_app


app = create_app({
    'SECRET_KEY': 'secret',
    'OAUTH2_REFRESH_TOKEN_GENERATOR': True,
    'SQLALCHEMY_TRACK_MODIFICATIONS': False,
    'SQLALCHEMY_DATABASE_URI': 'sqlite:///db.sqlite',
    'JWT_SECRET_KEY': 'my-secret-key',
    'JWT_ACCESS_TOKEN_EXPIRES': datetime.timedelta(hours=24)
})

access_logger = logging.getLogger('access_logger')
access_logger.setLevel(logging.INFO)

# 创建 RotatingFileHandler 来分割日志文件
app_path = os.path.dirname(os.path.abspath(__file__))
log_file = os.path.join(app_path, "logs", "access.log")
max_log_size = 10 * 1024 * 1024  # 10MB，你可以根据需要调整大小
backup_count = 5  # 保留的备份日志文件数量
file_handler = RotatingFileHandler(log_file, maxBytes=max_log_size, backupCount=backup_count)
log_format = '%(asctime)s [%(levelname)s] :%(message)s'
formatter = logging.Formatter(log_format)
file_handler.setFormatter(formatter)
access_logger.addHandler(file_handler)


@app.before_request
def access_log_info():
    ip_address = request.remote_addr
    method = request.method
    url = request.url
    if method == "POST":
        _t = request.form
    else:
        _t = request.args
    access_logger.info(
        "Request from %s - %s %s. Request data: %s", ip_address, method, url, json.dumps(_t, ensure_ascii=False))


if __name__ == '__main__':
    app.run('0.0.0.0', '8003', debug=True,)
