## FastAPI  

1. 目录说明
- app: 包含 FastAPI 应用程序的主要代码和配置。
    - api: 包含 API 相关的代码。
        - __init__.py: 初始化 API 模块。
        - routes.py: 定义 API 路由和请求处理函数。
        - models.py: 定义数据库模型。
        - schemas.py: 定义请求和响应模型的 Pydantic 模式。
    - core: 包含应用程序的核心组件和配置。
        - __init__.py: 初始化 Core 模块。
        - config.py: 应用程序配置参数的定义。
        - security.py: 处理身份验证和授权相关的功能。
        - database.py: 数据库连接和 ORM 配置。
    - services: 包含业务逻辑的服务层代码。
        - __init__.py: 初始化 Services 模块。
        - user_service.py: 处理用户相关的业务逻辑。
        - product_service.py: 处理产品相关的业务逻辑。
    main.py: FastAPI 应用程序的入口文件。
- tests: 包含测试代码。
    - api: API 相关的测试代码。
        - test_routes.py: 测试 API 路由和请求处理函数。
    - services: 服务层相关的测试代码。
        - test_user_service.py: 测试用户服务。
    conftest.py: 全局测试配置和夹具。
- README.md: 项目说明文档。
- requirements.txt: 依赖包列表。