import hashlib
from sqlalchemy import Column, Integer, String, DateTime, Text
from datetime import datetime
from myapp.core.database import Base, db, engine


class User(Base):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    username = Column(String, unique=True, index=True)
    password = Column(String)
    nickname = Column(String)
    avatar = Column(Text)
    cellphone = Column(String, unique=True, index=True)
    email = Column(String, unique=True, index=True)
    created_at = Column(DateTime, default=datetime.now)
    updated_at = Column(DateTime, default=datetime.now, onupdate=datetime.now)

    def hash_password(self, password: str) -> str:
        """
        对密码进行哈希加密
        """
        salt_pwd = password + str(self.created_at)
        return hashlib.md5(salt_pwd.encode()).hexdigest()

    def verify_password(self, password: str) -> bool:
        """
        验证密码是否匹配
        """
        hashed_password = self.hash_password(password)
        return self.password == hashed_password

    @classmethod
    def create_user(cls, username: str, password: str, **kwargs) -> 'User':
        """
        创建新用户
        """
        email = kwargs.get("email")
        phone = kwargs.get("phone")
        user = cls(username=username, email=email, phone=phone)
        user.password = user.hash_password(password)
        # 可以在这里添加其他逻辑，如保存到数据库等
        with db as session:
            session.add(user)
            session.commit()

        return user

    @classmethod
    def check_user_exist(cls, key: str="username", value: str="") -> bool:
        pass